/**
* Copyright (C) 2012, Crestron Electronics, Inc.  All rights reserved.
* No part of this software may be reproduced in any form, machine or natural,
* without the express written consent of Crestron.
*
* \file     (See the name of this file).
* \brief    (See comments in the associated header file).
* \detail   (None).
* \author   Richard Ting, Arto Kiremitdjian
* \date     1/27/2012
* \warning  (See comments, if any, in the associated header file).
* \note     (See comments, if any, in the associated header file).
* \review   (Pending review).
**/
//-------------------------------------------------------------------------
// Include files.

//#include <windows.h>
//#include <stdlib.h> // NULL

#include <linux/module.h>
//#include <linux/i2c.h>
//#include <linux/slab.h>

#include <linux/types.h>
//#include <linux/errno.h>
//#include <linux/fs.h>
//#include <linux/miscdevice.h>
//#include <linux/fcntl.h>
//#include <linux/init.h>
//#include <linux/smp_lock.h>
//#include <linux/slab.h>
//#include <asm/uaccess.h>
//#include <linux/delay.h>

#include "CRC.h" // What to implement.

//-------------------------------------------------------------------------
// Preprocessor defines.

//-------------------------------------------------------------------------
// Type definitions.

//-------------------------------------------------------------------------
// Local data/variables (declarations and definitions).

static u32 const Polynomial = 0x04C11DB7;
static u32 LookupTable[256] = {0};

//-------------------------------------------------------------------------
// Local function declarations.

//-------------------------------------------------------------------------
// Local function definitions.

//-------------------------------------------------------------------------
// Global definitions (functions and data).

void InitCRCLookupTable ()
{
	u32 i, j;
    for (i = 0; i < (sizeof(LookupTable)/sizeof(*(LookupTable))); ++i)
    {
        u32 Divisor = i << 8;
        for (j = 0; j < 8; ++j)
        {
            if (Divisor & 0x8000)
            {
                Divisor <<= 1;
                LookupTable[i] <<= 1;
                LookupTable[i] ^= Polynomial;
                Divisor ^= (Polynomial >> 16);
            }
            else
            {
                LookupTable[i] <<= 1;
                Divisor <<= 1;
            }
        }
    }
}

/**
* \author   Richard Ting
* \date     2/24/2012
* \brief    Calculates CRC across the data.
* \note     uses 32 bit crc and 8 byte at a time lookup table.
* \warning  must contain an even interval of 8 bytes, otherwise could access data outside array bounds.
* \param    data - what to calculate the crc of.
* \param    datasize - amount of data in bytes.
* \param    initialRun - true resets initial value back to 0, false allows continuation of crc calculation so it can be done in multiple blocks.
* \return   CrcValueType: resulting CRC over the data (and previous if initialRun == false).
*/
CrcValueType CalculateRunningCRC (unsigned char const *const data, u32 const datasize, bool initialRun)
{
    CrcValueType remainder = 0;
	static CrcValueType prevRemainder = 0;
	u32 i, k;

    // Verify parameter(s).
    if (NULL != data)
    {
        //8 bytes at a time crc
		if(initialRun)
		{
			prevRemainder = 0;
			for (k = 0; k < 4; ++k)
			{
				prevRemainder <<= 8;
				prevRemainder |= data[k];
			}
		}
		else
		{
			for (k = 0; k < 4; ++k)
			{
				prevRemainder = LookupTable[prevRemainder >> 24] ^ ((prevRemainder << 8) | data[k]);
			}
		}
			
        for (i = 0; i < datasize - 4; ++i)
        {
            prevRemainder = LookupTable[prevRemainder >> 24] ^ ((prevRemainder << 8) | data[i + 4]);
        }
        //last 4 bytes need to shift in 0's for remainder
		remainder = prevRemainder;
        for (i = 0; i < 4; ++i)
        {
            remainder = LookupTable[remainder >> 24] ^ ((remainder << 8) | 0);
        }
//		printk("%s: CRC intermediate %x.\r\n", __FUNCTION__,prevRemainder);
    }
    else
    {
        printk("%s: BAD parameter: NULL pointer to data.\r\n", __FUNCTION__);
    }
    return remainder;
}
